<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('client_settings', function (Blueprint $table) {
            $table->enum('environment_type', ['local', 'simulation', 'production'])->default('simulation')->after('business_category');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('client_settings', function (Blueprint $table) {
            $table->dropColumn('environment_type');
        });
    }
};
