<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            // Primary key
            $table->id();

            // Client relationship
            $table->string('machine_id');
            $table->foreign('machine_id')->references('machine_id')->on('client_settings')->onDelete('cascade');
            $table->enum('status', ['PENDING', 'SUCCESS', 'FAILED'])->default('PENDING');
            $table->enum('invoice_kind', ['b2b', 'b2c'])->nullable();

            // Invoice basic info
            $table->string('invoice_number');
            $table->uuid('uuid');
            $table->enum('invoice_type', ['TAX_INVOICE', 'DEBIT_NOTE', 'CREDIT_NOTE']);
            $table->enum('payment_type', ['CASH', 'CHEQUE', 'CREDIT', 'BANK_ACCOUNT', 'BANK_CARD', 'MULTIPLE']);
            $table->date('invoice_date');
            $table->time('invoice_time');
            $table->string('currency', 3)->default('SAR');

            // Amount fields
            $table->decimal('total_amount_without_tax', 12, 2);
            $table->decimal('total_tax', 12, 2);
            $table->decimal('total_amount_with_tax', 12, 2);
            $table->decimal('rounding_amount', 12, 2)->default(0);

            // Seller address info
            $table->string('seller_street_name', 255);
            $table->string('seller_building_number', 4);
            $table->string('seller_plot_identification', 50);
            $table->string('seller_city_sub_division', 50);
            $table->string('seller_city', 50);
            $table->string('seller_postal_number', 10);

            // Optional buyer info (for B2B)
            $table->string('buyer_registration_name', 255)->nullable();
            $table->string('buyer_tax_number', 15)->nullable();
            $table->string('buyer_street_name', 255)->nullable();
            $table->string('buyer_building_number', 4)->nullable();
            $table->string('buyer_plot_identification', 50)->nullable();
            $table->string('buyer_city_subdivision_name', 50)->nullable();
            $table->string('buyer_city', 50)->nullable();
            $table->string('buyer_postal_number', 10)->nullable();

            // Notes
            $table->text('payment_note')->nullable();

            // For credit/debit notes
            $table->string('parent_invoice_id')->nullable();
            $table->text('invoice_note')->nullable();

            // Reporting results
            $table->json('invoice_items');
            $table->text('invoice_hash');
            $table->text('result')->nullable();

            // Timestamps
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
