<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('machine_id')->unique(); // Random Machine ID
            $table->string('email');
            $table->string('common_name');
            $table->string('organizational_unit_name');
            $table->string('organization_name');
            $table->string('tax_number');
            $table->string('short_ad_category');
            $table->string('egs_serial_number');
            $table->string('registration_number');
            $table->string('business_category');
            $table->text('private_key')->nullable();
            $table->text('cert_production')->nullable();
            $table->text('secret_production')->nullable();
            $table->json('result')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_settings');
    }
};
