<?php

namespace App\Sys\Services\Client;

use Exception;
use App\Sys\Services;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use App\Sys\Repositories\Client\ClientRepository;
use App\Sys\Repositories\Client\ClientSettingRepository;

class ClientService extends Services
{
    protected $clientRepository;
    protected $clientSettingRepository;

    public function __construct(
        ClientRepository $clientRepository,
        ClientSettingRepository $clientSettingRepository
    ) {
        $this->clientSettingRepository = $clientSettingRepository;
        $this->clientRepository = $clientRepository;
    }

    public function getAllClients()
    {
        $result = $this->clientRepository->getClients();

        if (! $result) {
            return false;
        }

        return $result;
    }

    public function getAllClientInvoices($clientId)
    {
        $result = $this->clientRepository->getClientInvoices($clientId);

        if (! $result) {
            return false;
        }

        return $result;
    }
    public function getClientMachines($clientId)
    {
        $result = $this->clientSettingRepository->getClientMachines($clientId);

        if (! $result) {
            return false;
        }

        return $result;
    }
}
