<?php

namespace App\Models;

use Bl\FatooraZatca\Casts\ZatcaCast;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    protected $casts = [
        'invoice_items' => 'array',
        'result' => ZatcaCast::class,
    ];

    protected $fillable = [
        'machine_id',
        'invoice_number',
        'invoice_kind',
        'uuid',
        'invoice_type',
        'payment_type',
        'invoice_date',
        'invoice_time',
        'currency',
        'vat_rate',
        'total_amount_without_tax',
        'total_tax',
        'total_amount_with_tax',
        'rounding_amount',
        'seller_street_name',
        'seller_building_number',
        'seller_plot_identification',
        'seller_city_sub_division',
        'seller_city',
        'seller_postal_number',
        'buyer_registration_name',
        'buyer_tax_number',
        'buyer_street_name',
        'buyer_building_number',
        'buyer_plot_identification',
        'buyer_city_subdivision_name',
        'buyer_city',
        'buyer_postal_number',
        'payment_note',
        'parent_invoice_id',
        'invoice_note',
        'invoice_items',
        'invoice_hash',
        'qr_code',
        'reporting_results',
        'status',
        'result'
    ];

    public function clientSetting()
    {
        return $this->belongsTo(ClientSetting::class, 'machine_id', 'machine_id');
    }

    public function client()
    {
        return $this->hasOneThrough(
            Client::class,
            ClientSetting::class,
            'machine_id',
            'id',
            'machine_id',
            'client_id'
        );
    }
}
