<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientSetting extends Model
{
    use HasFactory;
    protected $fillable = [
        'client_id',
        'machine_id',
        'email',
        'common_name',
        'organizational_unit_name',
        'organization_name',
        'tax_number',
        'short_ad_category',
        'egs_serial_number',
        'business_category',
        'environment_type',
        'registration_number',
        'result',
    ];

    protected $casts = [
        'result' => 'array',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'machine_id', 'machine_id');
    }
}
