<?php

namespace App\Http\Controllers;

use App\ApiResponse;
use App\Http\Resources\InvoiceResource;
use Illuminate\Http\Request;
use App\Sys\Services\Invoice\InvoiceService;

class InvoiceController extends Controller
{
    use ApiResponse;

    protected $invoiceService;

    public function __construct(InvoiceService $invoiceService)
    {
        $this->invoiceService = $invoiceService;
    }

    public function reportInvoice(Request $request)
    {
        $result = $this->invoiceService->reportInvoice($request->all());

        if (! $result) {
            $error = $this->invoiceService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, $result);
    }

    public function machineInvoices($machineId)
    {
        $result = $this->invoiceService->machineInvoices($machineId);

        if (! $result) {
            $error = $this->invoiceService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, InvoiceResource::collection($result));
    }

    public function resendInvoice($invoiceId)
    {
        $result = $this->invoiceService->resendInvoice($invoiceId);

        if (! $result) {
            $error = $this->invoiceService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'Invoice resent successfully', null, $result);
    }
}
