<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'tax_number'
    ];

    public function clientSettings()
    {
        return $this->hasMany(ClientSetting::class);
    }

    public function invoices()
    {
        return $this->hasManyThrough(
            Invoice::class,
            ClientSetting::class,
            'client_id',
            'machine_id',
            'id',
            'machine_id'
        );
    }
}
