<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class InvoiceResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'machine_id' => $this->machine_id,
            'status' => $this->status,
            'invoice_kind' => $this->invoice_kind,
            'invoice_number' => $this->invoice_number,
            'uuid' => $this->uuid,
            'invoice_type' => $this->invoice_type,
            'payment_type' => $this->payment_type,
            'invoice_date' => $this->invoice_date,
            'invoice_time' => $this->invoice_time,
            'currency' => $this->currency,
            'vat_rate' => $this->vat_rate,
            'total_amount_without_tax' => $this->total_amount_without_tax,
            'total_tax' => $this->total_tax,
            'total_amount_with_tax' => $this->total_amount_with_tax,
            'rounding_amount' => $this->rounding_amount,

            // Seller information
            'seller_street_name' => $this->seller_street_name,
            'seller_building_number' => $this->seller_building_number,
            'seller_plot_identification' => $this->seller_plot_identification,
            'seller_city_sub_division' => $this->seller_city_sub_division,
            'seller_city' => $this->seller_city,
            'seller_postal_number' => $this->seller_postal_number,

            // Buyer information
            'buyer_registration_name' => $this->buyer_registration_name,
            'buyer_tax_number' => $this->buyer_tax_number,
            'buyer_street_name' => $this->buyer_street_name,
            'buyer_building_number' => $this->buyer_building_number,
            'buyer_plot_identification' => $this->buyer_plot_identification,
            'buyer_city_subdivision_name' => $this->buyer_city_subdivision_name,
            'buyer_city' => $this->buyer_city,
            'buyer_postal_number' => $this->buyer_postal_number,

            // Additional fields
            'payment_note' => $this->payment_note,
            'parent_invoice_id' => $this->parent_invoice_id,
            'invoice_note' => $this->invoice_note,
            'invoice_hash' => $this->invoice_hash,
            'qr_code' => $this->qr_code ? asset($this->qr_code) : null,

            'invoice_items' => $this->invoice_items,

            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
