<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class ApiLanguageManager
{
    protected $supportedLanguages = ['ar', 'en'];

    public function handle(Request $request, Closure $next)
    {
        $local = 'en';

        $headerLang = $request->header('x-lang');

        if (in_array($headerLang, $this->supportedLanguages, true)) {
            $local = $headerLang;
        }

        app()->setLocale($local);
        config(['app.fallback_locale' => $local]);

        return $next($request);
    }
}
