<?php

namespace App\Http\Controllers;

use App\ApiResponse;
use App\Http\Resources\InvoiceResource;
use App\Sys\Services\Client\ClientService;
use Illuminate\Http\Request;
use App\Sys\Services\Client\ClientSettingService;

class ClientController extends Controller
{
    use ApiResponse;

    protected $clientSettingService;
    protected $clientService;

    public function __construct(ClientSettingService $clientSettingService, ClientService $clientService)
    {
        $this->clientSettingService = $clientSettingService;
        $this->clientService = $clientService;
    }

    public function index()
    {
        $result = $this->clientService->getAllClients();

        if (! $result) {
            $error = $this->clientSettingService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, $result);
    }
    public function getClientInvoices($clientId)
    {
        $result = $this->clientService->getAllClientInvoices($clientId);

        if (! $result) {
            $error = $this->clientSettingService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, InvoiceResource::collection($result));
    }

    public function registerMachine(Request $request)
    {
        $result = $this->clientSettingService->registerMachine($request->all());

        if (! $result) {
            $error = $this->clientSettingService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, ['machine_id' => $result]);
    }

    public function clientMachines($clientId)
    {
        $result = $this->clientService->getClientMachines($clientId);

        if (! $result) {
            $error = $this->clientSettingService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'All data', null, $result);
    }
}
