<?php

namespace App\Sys\Repositories\Invoice;

use App\Models\Invoice;
use App\Enums\InvoiceStatus;

class InvoiceRepository
{
    public function lastClientInvoice($clientId, $invoiceType)
    {
        return Invoice::where('machine_id', $clientId)
            ->where('status', InvoiceStatus::SUCCESS)
            ->where('invoice_type', $invoiceType)
            ->orderByDesc('updated_at')
            ->first();
    }

    public function createInvoice($request, $invoiceNumber, $generatedUuid)
    {
        $invoice = new Invoice();

        $invoice->machine_id = $request['machine_id'];
        $invoice->status = 'PENDING';
        $invoice->invoice_kind = ($request['buyer_registration_name'] ?? null) ? 'b2b' : 'b2c';
        $invoice->invoice_number = $invoiceNumber;
        $invoice->uuid = $generatedUuid;
        $invoice->invoice_type = $request['invoice_type'];
        $invoice->payment_type = $request['payment_type'];
        $invoice->invoice_date = now()->format('Y-m-d');
        $invoice->invoice_time = now()->format('H:i:s');
        $invoice->currency = 'SAR';
        $invoice->vat_rate = $request['vat_rate'];
        $invoice->total_amount_without_tax = $request['total_amount_without_tax'];
        $invoice->total_tax = $request['total_tax'];
        $invoice->total_amount_with_tax = $request['total_amount_with_tax'];
        $invoice->rounding_amount = $request['rounding_amount'] ?? 0;
        $invoice->seller_street_name = $request['street_name'];
        $invoice->seller_building_number = $request['building_number'];
        $invoice->seller_plot_identification = $request['plot_identification'];
        $invoice->seller_city_sub_division = $request['city_sub_division'];
        $invoice->seller_city = $request['city'];
        $invoice->seller_postal_number = $request['postal_number'];
        $invoice->buyer_registration_name = $request['buyer_registration_name'] ?? null;
        $invoice->buyer_tax_number = $request['buyer_tax_number'] ?? null;
        $invoice->buyer_street_name = $request['buyer_street_name'] ?? null;
        $invoice->buyer_building_number = $request['buyer_building_number'] ?? null;
        $invoice->buyer_plot_identification = $request['buyer_plot_identification'] ?? null;
        $invoice->buyer_city_subdivision_name = $request['buyer_city_subdivision_name'] ?? null;
        $invoice->buyer_city = $request['buyer_city'] ?? null;
        $invoice->buyer_postal_number = $request['buyer_postal_number'] ?? null;
        $invoice->payment_note = $request['payment_note'] ?? null;
        $invoice->parent_invoice_id = $request['parent_invoice_id'] ?? null;
        $invoice->invoice_note = $request['invoice_note'] ?? null;
        $invoice->invoice_items = $request['invoice_items'];
        $invoice->invoice_hash = '';
        $invoice->result = null;

        $invoice->save();

        return $invoice;
    }

    public function updateInvoiceStatus(Invoice $invoice, $status, $invoiceHash = null, $result = null, $invoiceNumber = null)
    {
        $invoice->status = $status;

        if ($invoiceHash !== null) {
            $invoice->invoice_hash = $invoiceHash;
        }

        if ($result !== null) {
            $invoice->result = serialize($result);
        }

        if ($invoiceNumber !== null) {
            $invoice->invoice_number = $invoiceNumber;
        }

        return $invoice->save();
    }

    public function getMachineInvoices($machineId)
    {
        return Invoice::where('machine_id', $machineId)
            ->latest()
            ->paginate(10);
    }

    public function findFailedInvoice($invoiceId)
    {
        return Invoice::where('id', $invoiceId)
            ->whereIn('status', [InvoiceStatus::FAILED, InvoiceStatus::PENDING])
            ->first();
    }
}
