<?php

namespace App\Sys\Repositories\Client;

use App\Models\ClientSetting;

class ClientSettingRepository
{
    public function create($clientData)
    {
        return ClientSetting::create([
            'client_id' => $clientData['client_id'],
            'machine_id' => $clientData['machine_id'],
            'email' => $clientData['email'],
            'common_name' => $clientData['common_name'],
            'organizational_unit_name' => $clientData['organizational_unit_name'],
            'organization_name' => $clientData['organization_name'],
            'tax_number' => $clientData['tax_number'],
            'short_ad_category' => $clientData['short_ad_category'],
            'egs_serial_number' => $clientData['egs_serial_number'],
            'business_category' => $clientData['business_category'],
            'registration_number' => $clientData['registration_number'],
            'private_key' => $clientData['private_key'],
            'cert_production' => $clientData['cert_production'],
            'secret_production' => $clientData['secret_production'],
            'result' => $clientData['result'],
        ]);
    }

    public function findByMachineId($machineId)
    {
        return ClientSetting::where('machine_id', $machineId)->first();
    }

    public function findByClientId($clientId)
    {
        return ClientSetting::where('client_id', $clientId)->get();
    }

    public function getClientMachines($clientId)
    {
        return ClientSetting::where('client_id', $clientId)
            ->latest()
            ->paginate(10);
    }
}