<?php

namespace App\Sys\Repositories\Client;

use App\Models\Client;
use App\Models\ClientSetting;

class ClientRepository
{
    public function create($clientData)
    {
        return Client::create([
            'name' => $clientData['name'],
            'email' => $clientData['email'],
            'tax_number' => $clientData['tax_number'],
        ]);
    }

    public function findByClientId($clientId)
    {
        return Client::findOrFail($clientId);
    }

    public function getClientInvoices($clientId)
    {
        $client = Client::findOrFail($clientId);

        $paginatedInvoices = $client->invoices()->latest()->paginate(10);

        return $paginatedInvoices;
    }

    public function getClients()
    {
        return Client::latest()->paginate(10);
    }
}
