<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class InvoiceValidationRule implements Rule
{
    public function passes($attribute, $value)
    {
        // Not needed for this approach
        return false;
    }

    public function message()
    {
        // Not needed for this approach
        return '';
    }

    public static function rules()
    {
        return [
            'machine_id' => ['required', 'exists:client_settings,machine_id'],
            'invoice_type' => ['required', 'string', 'in:TAX_INVOICE,DEBIT_NOTE,CREDIT_NOTE'],
            'payment_type' => ['required', 'string', 'in:CASH,CHEQUE,CREDIT,BANK_ACCOUNT,BANK_CARD,MULTIPLE'],
            'street_name' => ['required', 'string', 'max:255'],
            'building_number' => ['required', 'string', 'digits:4'],
            'plot_identification' => ['required', 'string', 'max:50'],
            'city_sub_division' => ['required', 'string', 'max:50'],
            'city' => ['required', 'string', 'max:50'],
            'postal_number' => ['required', 'string', 'max:10'],
            'total_amount_without_tax' => ['required', 'numeric', 'min:0'],
            'vat_rate' => ['required', 'numeric', 'min:0'],
            'total_tax' => ['required', 'numeric', 'min:0'],
            'total_amount_with_tax' => ['required', 'numeric', 'min:0'],
            'rounding_amount' => ['nullable', 'numeric'],
            'payment_note' => ['nullable', 'string'],
            'parent_invoice_id' => ['nullable', 'exists:invoices,invoice_number'],
            'invoice_note' => ['nullable', 'string', 'max:255'],
            'invoice_items' => ['required', 'array', 'min:1'],
            'invoice_items.*.name' => ['required', 'string', 'max:255'],
            'invoice_items.*.quantity' => ['required', 'numeric', 'min:1'],
            'invoice_items.*.unit_price' => ['required', 'numeric', 'min:0'],
            'invoice_items.*.discount' => ['nullable', 'numeric', 'min:0'],
            'invoice_items.*.tax_amount' => ['required', 'numeric', 'min:0'],
            'invoice_items.*.tax_rate' => ['required', 'numeric', 'min:0'],
            'invoice_items.*.total_amount' => ['required', 'numeric', 'min:0'],
            'invoice_items.*.discount_note' => ['nullable', 'string', 'max:50'],
            'invoice_items.*.tax_category' => ['nullable', 'string', 'in:ZERO_RATE,EXEMPT,OUT_OF_SCOPE'],
            // Buyer details for B2B
            'buyer_registration_name' => ['sometimes', 'required_with:buyer_tax_number', 'string', 'max:255'],
            'buyer_tax_number' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:15'],
            'buyer_street_name' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:255'],
            'buyer_building_number' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'digits:4'],
            'buyer_plot_identification' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:50'],
            'buyer_city_subdivision_name' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:50'],
            'buyer_city' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:50'],
            'buyer_postal_number' => ['sometimes', 'required_with:buyer_registration_name', 'string', 'max:10'],
        ];
    }
}
